import {COUNTRY_CODE_UA} from 'projects/trains/constants/countries';

import {TTrainsOrderSelectorSegment} from 'projects/trains/lib/segments/types';

// Проверка, что у сегмента страна станции отправления или станции прибытия не находится в Украине.
export function isUkrainianSegment(
    segment: TTrainsOrderSelectorSegment,
): boolean {
    const {stationFrom, stationTo} = segment;

    return Boolean(
        stationFrom &&
            stationTo &&
            stationFrom.country &&
            stationTo.country &&
            (stationFrom.country.code === COUNTRY_CODE_UA ||
                stationTo.country.code === COUNTRY_CODE_UA),
    );
}
