import {Overwrite} from 'utility-types';

import {USSR_COUNTRIES} from 'projects/trains/constants/countries';

import {IDeluxeTrain, IThread} from 'projects/trains/lib/segments/types';

/**
 * Проверка, что нитка начинается или заканчивается в пределах бывшего СССР.
 *
 * @param thread - объект нитки
 */
export default function isUssrThread(
    thread: Overwrite<IThread, {deluxeTrain?: IDeluxeTrain | null}>,
): boolean {
    // firstCountryCode - страна начала нитки
    // lastCountryCode - страна конца нитки
    return Boolean(
        thread &&
            thread.firstCountryCode &&
            thread.lastCountryCode &&
            USSR_COUNTRIES.includes(thread.firstCountryCode) &&
            USSR_COUNTRIES.includes(thread.lastCountryCode),
    );
}
