import {
    isTrainsCoachType,
    isTrainsCoachTypes,
    TRAIN_COACH_TYPE,
} from 'projects/trains/constants/coachType';

import {ITrainsTariffApiSegment} from 'server/api/TrainsApi/types/ITrainsGetTariffsApi/models';

import IPrice from 'utilities/currency/PriceInterface';

/**
 * Классы тарифов сегмента.
 *
 * @param segment - данные сегмента
 */
export function getTariffClassKeys(
    segment: ITrainsTariffApiSegment,
): TRAIN_COACH_TYPE[] {
    const tariffsKeys =
        'tariffs' in segment &&
        segment.tariffs &&
        segment.tariffs.classes &&
        Object.keys(segment.tariffs.classes);

    if (!tariffsKeys || !isTrainsCoachTypes(tariffsKeys)) {
        return [];
    }

    return tariffsKeys;
}

export interface IPriceWithTariffName extends IPrice {
    tariffName: TRAIN_COACH_TYPE;
}

export function isPriceWithTariffName(
    price: IPrice | IPriceWithTariffName,
): price is IPriceWithTariffName {
    return 'tariffName' in price;
}

/**
 * Возвращает массив цен на билеты для сегмена
 */
export function getSegmentPrices(
    segment: ITrainsTariffApiSegment,
): IPriceWithTariffName[] {
    const prices: IPriceWithTariffName[] = [];

    if (
        'tariffs' in segment &&
        segment.tariffs?.classes &&
        Object.keys(segment.tariffs.classes).length !== 0
    ) {
        Object.entries(segment.tariffs.classes).forEach(
            ([tariffName, data]) => {
                if (data?.price?.value && isTrainsCoachType(tariffName)) {
                    prices.push({
                        value: data.price.value,
                        currency: data.price.currency,
                        tariffName,
                    });
                }
            },
        );
    }

    return prices;
}
