import {TRAIN_COACH_TYPE} from 'projects/trains/constants/coachType';

import {TTrainsStoreOrderSegment} from 'projects/trains/lib/segments/types';

/**
 * Сортирует тарифы внутри сегмента
 *
 * @param tariffClassKeys - ключи тарифов
 * @param segment - данные сегмента
 */
export function sortTariffClassKeys(
    tariffClassKeys: TRAIN_COACH_TYPE[],
    segment: TTrainsStoreOrderSegment | null,
): TRAIN_COACH_TYPE[] {
    if (tariffClassKeys.length === 0 || !segment) {
        return tariffClassKeys;
    }

    const classes =
        'tariffs' in segment && segment.tariffs && segment.tariffs.classes;

    return tariffClassKeys.sort((a, b) => {
        if (!classes) {
            return 0;
        }

        const classA = classes[a];
        const classB = classes[b];

        if (!classA || !classB) {
            return 0;
        }

        return classA.price.value - classB.price.value;
    });
}
