import {Moment} from 'moment';
import {$Keys} from 'utility-types';

import {TRAIN_COACH_TYPE} from 'projects/trains/constants/coachType';

import {ITrainOrderApiSegment} from 'server/api/RaspApi/types/IRaspGetTrainOrderSegmentApi/models';
import {
    ITrainsTariffApiSegment,
    ITrainsTariffs,
} from 'server/api/TrainsApi/types/ITrainsGetTariffsApi/models';

import IPrice from 'utilities/currency/PriceInterface';

export enum ETrainsBrokenClassCode {
    UNKNOWN = 0,
    SOLD_OUT = 1, // нет мест
    TRANSIT_DOCUMENT_REQUIRED = 2, // признак IsTransitDocumentRequired=true от партнера
    NOT_AVAILABLE_IN_WEB = 3, // из признака AvailabilityIndication от партнера
    FEATURE_NOT_ALLOWED = 4, // из признака AvailabilityIndication от партнера
    SERVICE_NOT_ALLOWED = 5, // из признака AvailabilityIndication от партнера
    CARRIER_NOT_ALLOWED_FOR_SALES = 6, // из признака AvailabilityIndication от партнера
    OTHER_REASON_OF_INACCESSIBILITY = 7, // из признака AvailabilityIndication от партнера
    UNSUPPORTED_RESERVATION_TYPE = 8, // поддерживаются PlaceReservationType USUAL, TWO_PLACES_AT_ONCE, FOUR_PLACES_AT_ONCE
    TOO_CHEAP = 9, // MinPrice меньше 10р
    UNSUPPORTED_COACH_TYPE = 10, // поддерживаются ReservedSeat, Compartment, Luxury, Shared, Sedentary, Soft
    CHILD_TARIFF = 11, // в ответе CarPricing если в CarDescription есть '*Д'
}

export type TTrainsBrokenClasses = Partial<
    Record<TRAIN_COACH_TYPE, ETrainsBrokenClassCode[]>
>;

export interface ITariffClass {
    price: IPrice;
    title?: string;
    orderUrl: string;
    seats: number;
    trainOrderUrl: string;
    trainOrderUrlOwner: string;
}

export type TTariffClasses = Partial<Record<TRAIN_COACH_TYPE, ITariffClass>>;

export interface ICompany {
    hidden: boolean;
    id: number;
    shortTitle: string;
    ufsTitle: string; // Используется для рейсов пополнения
    title: string;
    url: string;
    yandexAviaUrl: null;
}

export interface IDeluxeTrain {
    shortTitle: string;
    title: string;
    isDeluxe: boolean;
    isHighSpeed: boolean;
    id: number;
}

export interface IThread {
    beginTime: null;
    comment: string;
    density: string;
    displaceYabus: null;
    endTime: null;
    firstCountryCode: string;
    isAeroExpress: boolean;
    isBasic: boolean;
    isExpress: boolean;
    lastCountryCode: string;
    number: string;
    schedulePlanCode: null;
    title: string;
    uid: string;
    deluxeTrain?: IDeluxeTrain;
}

export interface IStationSettlement {
    id?: number;
    preposition?: string;
    title: string;
    titleAccusative?: string;
    titleGenitive?: string;
    titleLocative?: string;
}

export interface IStation {
    codes: {
        express: string;
    };
    country: {
        code: string;
        id: number;
    };
    id: number;
    platform?: string;
    popularTitle: string;
    railwayTimezone: string;
    settlementId: number;
    settlement?: IStationSettlement;
    title: string;
    timezone: string;
}

export interface ITransport {
    code: string;
    id: number;
    title: string;
    model?: {
        title: string;
    };
    subtype?: {
        code: string;
        id: number;
        title: string;
        titleColor: string;
    };
}

export interface ITrainsMinTariffClass {
    price: IPrice;
}

export type TTrainsStoreOrderSegment =
    | ITrainOrderApiSegment
    | ITrainsTariffApiSegment;

/**
 * Селектор сегмента заказа
 */

interface ITrainsOrderSelectorSegmentPatch {
    tariffs?:
        | {
              electronicTicket: boolean;
          }
        | ITrainsTariffs;
    departureMoment: Moment;
    departureRailwayMoment: Moment | null;
    arrivalMoment: Moment;
    arrivalRailwayMoment: Moment | null;
    thread: IThread | null;
    originalArrival?: string;
    isThroughCoachArrival?: boolean;
}

type TTrainsHelperOrderSegmentTypeWithoutTariffs =
    | Omit<ITrainOrderApiSegment, $Keys<ITrainsOrderSelectorSegmentPatch>>
    | Omit<ITrainsTariffApiSegment, $Keys<ITrainsOrderSelectorSegmentPatch>>;

export type TTrainsOrderSelectorSegment =
    TTrainsHelperOrderSegmentTypeWithoutTariffs &
        ITrainsOrderSelectorSegmentPatch;
