import {Moment} from 'moment-timezone';

import trainsSegmentsSortCommonComparator from 'projects/trains/lib/sort/comparators/helpers/trainsSegmentsSortCommonComparator';

export interface ITrainsDateTimeSortingComparatorData {
    moment: Moment;
    tariffsKeys?: string[];
    id?: string;
}

/**
 * Функция сравнения двух сегментов для определения порядка сортировки по времени отправления/прибытия на конкретный день.
 */
export default function trainsDateTimeSortingComparator(
    {
        moment: momentA,
        tariffsKeys: tariffsKeysA,
        id: idA,
    }: ITrainsDateTimeSortingComparatorData,
    {
        moment: momentB,
        tariffsKeys: tariffsKeysB,
        id: idB,
    }: ITrainsDateTimeSortingComparatorData,
    isReverse: boolean,
): number {
    if (isReverse && !momentA.isSame(momentB, 'day')) {
        return momentB.isAfter(momentA, 'day') ? 1 : -1;
    }

    if (momentA.isSame(momentB)) {
        return trainsSegmentsSortCommonComparator(
            tariffsKeysA,
            tariffsKeysB,
            idA,
            idB,
        );
    }

    return momentA.isAfter(momentB) ? 1 : -1;
}
