import trainsSegmentsSortCommonComparator from 'projects/trains/lib/sort/comparators/helpers/trainsSegmentsSortCommonComparator';

export interface ITrainsDurationsSortingComparatorData {
    duration: number;
    tariffsKeys?: string[];
    id?: string;
}

/**
 * Функция сравнения двух сегментов для определения порядка сортировки по времени в пути.
 */
export default function trainsDurationSortingComparator(
    {
        duration: durationA,
        tariffsKeys: tariffsKeysA,
        id: idA,
    }: ITrainsDurationsSortingComparatorData,
    {
        duration: durationB,
        tariffsKeys: tariffsKeysB,
        id: idB,
    }: ITrainsDurationsSortingComparatorData,
): number {
    return (
        durationA - durationB ||
        trainsSegmentsSortCommonComparator(tariffsKeysA, tariffsKeysB, idA, idB)
    );
}
