import trainsSegmentsSortCommonComparator from 'projects/trains/lib/sort/comparators/helpers/trainsSegmentsSortCommonComparator';
import IPrice from 'utilities/currency/PriceInterface';

export interface ITrainsPriceSortingComparatorData {
    price: IPrice;
    tariffsKeys?: string[];
    id?: string;
}

/**
 * Функция сравнения двух сегментов для определения порядка сортировки по цене.
 */
export default function trainsPriceSortingComparator(
    {
        price: priceA,
        tariffsKeys: tariffsKeysA,
        id: idA,
    }: ITrainsPriceSortingComparatorData,
    {
        price: priceB,
        tariffsKeys: tariffsKeysB,
        id: idB,
    }: ITrainsPriceSortingComparatorData,
): number {
    return (
        priceA.value - priceB.value ||
        trainsSegmentsSortCommonComparator(tariffsKeysA, tariffsKeysB, idA, idB)
    );
}
