import {Moment} from 'moment-timezone';

import trainsSegmentsSortCommonComparator from 'projects/trains/lib/sort/comparators/helpers/trainsSegmentsSortCommonComparator';

export interface ITrainsTimeSortingComparatorData {
    moment: Moment;
    tariffsKeys?: string[];
    id?: string;
}

/**
 * Функция сравнения двух сегментов для определения порядка сортировки по времени отправления/прибытия на все дни.
 */
export default function trainsTimeSortingComparator(
    {
        moment: momentA,
        tariffsKeys: tariffsKeysA,
        id: idA,
    }: ITrainsTimeSortingComparatorData,
    {
        moment: momentB,
        tariffsKeys: tariffsKeysB,
        id: idB,
    }: ITrainsTimeSortingComparatorData,
): number {
    const hoursA = momentA.hours();
    const hoursB = momentB.hours();

    return (
        (hoursA === hoursB
            ? momentA.minutes() - momentB.minutes()
            : hoursA - hoursB) ||
        trainsSegmentsSortCommonComparator(tariffsKeysA, tariffsKeysB, idA, idB)
    );
}
