import {TRAINS_SEARCH_DEFAULT_SORT} from 'projects/trains/lib/sort/constants';

import {ITrainsSearchSort} from 'projects/trains/lib/sort/types';

export interface ITrainsSortingQuery {
    sortBy: string | undefined;
}

/**
 * Функция возвращает Get-параметры для сортировки.
 */
export default function getTrainsSortingQuery(
    sort: ITrainsSearchSort,
): ITrainsSortingQuery {
    return {
        sortBy:
            sort.by === TRAINS_SEARCH_DEFAULT_SORT.by &&
            sort.isReverse === TRAINS_SEARCH_DEFAULT_SORT.isReverse
                ? undefined
                : `${sort.isReverse ? '-' : ''}${sort.by}`,
    };
}
