import {TRAINS_SEARCH_DEFAULT_SORT} from 'projects/trains/lib/sort/constants';

import {
    isTrainsSearchSortField,
    ITrainsSearchSort,
} from 'projects/trains/lib/sort/types';

/**
 * Функция парсит get-параметр sortBy и делает из него объект сортировки.
 */
export default function parseTrainsSortingQuery(
    sortByParam: string | undefined,
): ITrainsSearchSort {
    if (!sortByParam) {
        return TRAINS_SEARCH_DEFAULT_SORT;
    }

    const isReverse = sortByParam.startsWith('-');
    const sortingField = isReverse ? sortByParam.substr(1) : sortByParam;

    if (!isTrainsSearchSortField(sortingField)) {
        return TRAINS_SEARCH_DEFAULT_SORT;
    }

    return {
        by: sortingField,
        isReverse,
    };
}
