import {ESortType} from 'types/common/sort/ESortType';

export {ESortType as TrainsSearchSortField} from 'types/common/sort/ESortType';

export const TRAINS_SEARCH_SORT_TYPES = Object.values(ESortType);

export function isTrainsSearchSortField(field: any): field is ESortType {
    return TRAINS_SEARCH_SORT_TYPES.includes(field);
}

export interface ITrainsSearchSort {
    by: ESortType;
    isReverse: boolean;
}
