import {SVG_NAMESPACE} from 'projects/trains/constants/namespaces';
import {GENDER_TYPE} from 'projects/trains/constants/genders';

import {makeCacheable} from 'projects/trains/lib/cache';

import * as i18nBlock from 'i18n/trains-transport-schema';

import getCompartmentGenderText from './getCompartmentGenderText';

export const PLACE_SIZE = 24;

function genderTitleWithoutCache(gender: GENDER_TYPE): SVGTextElement {
    const titleElement = document.createElementNS(SVG_NAMESPACE, 'text');
    const genderTitleElement = document.createElementNS(SVG_NAMESPACE, 'tspan');
    const groupTitleElement = document.createElementNS(SVG_NAMESPACE, 'tspan');

    genderTitleElement.textContent = getCompartmentGenderText(gender);
    groupTitleElement.textContent = i18nBlock.coachDashGenderDashGroup();

    titleElement.classList.add('Place__genderTitle');
    titleElement.setAttribute('text-anchor', 'middle');
    groupTitleElement.setAttribute('dy', '1.2em');

    titleElement.appendChild(genderTitleElement);
    titleElement.appendChild(groupTitleElement);

    return titleElement;
}

const genderTitle = makeCacheable(genderTitleWithoutCache);

export function getGenderTitle(
    gender: GENDER_TYPE,
    {x, y}: {x: number; y: number},
): Node {
    const title = genderTitle(gender).cloneNode(true);

    for (const node of title.childNodes) {
        (node as SVGElement).setAttribute('x', String(x));
        (node as SVGElement).setAttribute('y', String(y));
    }

    return title;
}
