import {PASSENGERS_TYPES} from 'projects/trains/constants/passengersTypes';

import ITrainPassenger from 'server/api/GenericOrderApi/types/common/service/ITrainServiceInfo/ITrainPassenger/ITrainPassenger';
import {ITrainsTariffCategory} from 'server/api/TrainsApi/types/ITrainsDetailsApiResponse';

import {getAgeGroup} from 'projects/trains/lib/order/fields/birthDate';
import {externalUrl} from 'utilities/url';

export interface IFeedbackOrderDetails {
    uid: string;
    passengers?: ITrainPassenger[];
}

const TYPE_PARAM = `form9582-type`;
const NAME_PARAM = `form9582-name`;
const SURNAME_PARAM = `form9582-surname`;
const ORDER_PARAM = `form9582-order`;

const TROUBLE_WITH_PAYMENT = {
    [TYPE_PARAM]: 104509,
};
const FEEDBACK_PATH = '//yandex.ru/support/trains/troubleshooting.html';

export interface IFeedbackFormParams {
    [TYPE_PARAM]?: number;
    [NAME_PARAM]?: string;
    [SURNAME_PARAM]?: string;
    [ORDER_PARAM]?: string;
}

/**
 * Вернёт ссылку на форму обратной связи
 */
function getFeedbackLink(params: IFeedbackFormParams): string {
    return externalUrl(FEEDBACK_PATH, params);
}

/**
 * Вернёт объект с полями для автозаполнения формы
 */
function getFeedbackFormOrderParams(
    orderDetails?: IFeedbackOrderDetails | null,
    tariffCategories?: ITrainsTariffCategory[],
): IFeedbackFormParams {
    const orderParams: IFeedbackFormParams = {};

    if (!orderDetails || !tariffCategories) {
        return orderParams;
    }

    const {uid, passengers} = orderDetails;

    if (passengers) {
        const adultPassenger = passengers.find(
            ({age}) =>
                getAgeGroup(age, tariffCategories) === PASSENGERS_TYPES.ADULTS,
        );

        if (adultPassenger) {
            orderParams[NAME_PARAM] = adultPassenger.firstName;
            orderParams[SURNAME_PARAM] = adultPassenger.lastName;
        }
    }

    if (uid) {
        orderParams[ORDER_PARAM] = uid;
    }

    return orderParams;
}

/**
 * Вернёт ссылку на форму обратной связи с параметрами автозаполнения
 * взятыми из данных заказа
 */
export function getOrderFeedbackUrl(
    orderDetails?: IFeedbackOrderDetails | null,
    tariffCategories?: ITrainsTariffCategory[],
) {
    return getFeedbackLink({
        ...getFeedbackFormOrderParams(orderDetails, tariffCategories),
        ...TROUBLE_WITH_PAYMENT,
    });
}
