import {URLs} from 'constants/urls';

import {IInternalUrlOptions} from 'utilities/url/types';
import {EFirmTrain} from 'types/trains/seoPages/firmTrain/TFirmTrainBlock';

import {internalUrl} from 'utilities/url';

export default function getFirmTrainPageUrl({
    slug,
    options,
}: {
    slug: EFirmTrain;
    options?: IInternalUrlOptions;
}): string {
    return internalUrl(`${URLs.trainsRoot}/${slug}/`, null, options);
}
