import {URLs} from 'constants/urls';

import {IUrlQuery} from 'utilities/url/types';

import {internalUrl} from 'utilities/url';

export function getTrainsPartnerRedirectUrl({
    fromId,
    fromName,
    toId,
    toName,
    when,
    time,
    number,
}: IUrlQuery): string {
    return internalUrl(
        URLs.trainsPartnerRedirect,
        {
            fromId,
            fromName,
            toId,
            toName,
            when,
            time,
            number,
        },
        {filterNull: true},
    );
}
