import {TLD} from 'constants/tld';

import {externalUrl} from 'utilities/url';

import {getExternalTrainsProjectUrl} from './getExternalTrainsProjectUrl';

/**
 * URL заказа на поездах.
 *
 * @param {string} uid - Уникальный айди заказа.
 * @param {string} tld - TLD в URL.
 *
 * @return {string}
 */
export function getTrainsAccessOrderUrl(uid: string, tld: TLD): string {
    return externalUrl(
        `${getExternalTrainsProjectUrl(tld)}/orders/access/${uid}/`,
    );
}
