import moment from 'moment';

import {ITrainRoutePart} from 'types/trains/booking/ITrainsOrderLocation';

import {ROBOT, TIME} from 'utilities/dateUtils/formats';

export const ROUTE_PART_SEPARATOR = '_';
export const ROUTE_WHEN_FORMAT = `${ROBOT}T${TIME}`;

/**
 * Парсит часть маршрута из параметров
 */
export function parseTrainRoutePart(route: string): ITrainRoutePart {
    const [provider, number, fromId, toId, when] =
        route.split(ROUTE_PART_SEPARATOR);

    return {
        provider,
        number,
        fromId: normalizeId(fromId),
        toId: normalizeId(toId),
        when: moment(when, ROUTE_WHEN_FORMAT),
    };
}

export function stringifyTrainRoutePart({
    provider,
    number,
    fromId,
    toId,
    when,
}: ITrainRoutePart): string {
    return [
        provider,
        number,
        fromId,
        toId,
        when.format(ROUTE_WHEN_FORMAT),
    ].join(ROUTE_PART_SEPARATOR);
}

/**
 * Для fromId и toId,
 * при получении c213(код города) или s200642(код станции) мы возвращаем id как есть
 * при получении числового значения считаем, что это код станции и приводим его к формату, добавляя s
 * @param id
 */
function normalizeId(id: string): string {
    if (isNaN(Number(id))) {
        return id;
    }

    return `s${id}`;
}
