import {TLD} from 'constants/tld';

import {externalUrl} from 'utilities/url';

import {getExternalTrainsProjectUrl} from './getExternalTrainsProjectUrl';

/**
 * URL заказа на поездах.
 *
 * @param uid - Уникальный айди заказа.
 * @param tld - TLD в URL.
 */
export function getTrainsOrderUrl(uid: string, tld: TLD): string {
    return externalUrl(`${getExternalTrainsProjectUrl(tld)}/orders/${uid}/`);
}
