import Cookie from 'js-cookie';

import {TRAIN_TEST_CONTEXT_TOKEN_COOKIE_NAME} from 'constants/testContext';

import appData from 'utilities/appData/appData';
import {getQueryByBrowserHistory} from 'utilities/getQueryByBrowserHistory/getQueryByBrowserHistory';

export function getTrainsTestContextTokens(): string[] {
    if (appData.isProductionEnv) {
        return [];
    }

    const query = getQueryByBrowserHistory();

    const {trainTestContextToken} = query;

    if (trainTestContextToken) {
        return Array.isArray(trainTestContextToken)
            ? trainTestContextToken
            : [trainTestContextToken];
    }

    const cookie = Cookie.get(TRAIN_TEST_CONTEXT_TOKEN_COOKIE_NAME);

    if (!cookie) {
        return [];
    }

    return cookie.split('&');
}
