import moment, {Moment} from 'moment-timezone';

import {TTrainsStoreOrderSegment} from 'projects/trains/lib/segments/types';

import {HUMAN_DATE_RU} from 'utilities/dateUtils/formats';
import {externalUrl} from 'utilities/url';

export const UFS_LINK = 'https://www.ufs-online.ru/kupit-zhd-bilety';
export const domain = 'yandex.ufs-online.ru';

/**
 * Возвращает ссылку покупки на УФС
 *
 * @param segment
 * @param [dayMoment] - Moment даты отправляния. Задается для формирования ссылки на определенную дату
 */
export function getUfsOrderUrl(
    segment: TTrainsStoreOrderSegment,
    dayMoment?: Moment,
): string {
    const {stationTo, stationFrom, departure} = segment;

    const path = `${UFS_LINK}/${stationFrom.codes.express}/${stationTo.codes.express}`;
    const date = (
        dayMoment || moment.tz(departure, stationFrom.timezone)
    ).format(HUMAN_DATE_RU);

    return externalUrl(path, {
        date,
        trainNumber: ('number' in segment && segment.number) || '',
        domain,
    });
}
