import {URLs} from 'constants/urls';

import {internalUrl} from 'utilities/url';
import getIndexPageUrl from 'projects/trains/lib/urls/getIndexPageUrl';
import getHappyPageUrl from 'projects/trains/lib/urls/getHappyPageUrl';

import {getTrainOrderUrl} from './getTrainOrderUrl';
import {getOrderFeedbackUrl} from './feedback';
import {getTrainsPartnerRedirectUrl} from './getTrainPartnerRedirectUrl';
import {getTrainsSearchUrl} from './getTrainsSearchUrl';
import {getUfsOrderUrl} from './getUfsOrderUrl';
import {getOrderStepUrl} from './getOrderStepUrl';
import {getTrainsOrderUrlBySearchParams} from './getTrainsOrderUrlBySearchParams';

const getFromOrderUrl = (orderUrl: string): string =>
    internalUrl(`${URLs.trains}${orderUrl}`);

export const trainsURLs = {
    getIndexPageUrl,
    getTrainOrderUrl,
    getOrderFeedbackUrl,
    getTrainsPartnerRedirectUrl,
    getTrainsSearchUrl,
    getUfsOrderUrl,
    getOrderStepUrl,
    getFromOrderUrl,
    getHappyPageUrl,
    getTrainsOrderUrlBySearchParams,
};
