import {DIRECTIONS, EDirection} from 'types/common/EDirection';

export type TPathDirection = 'forward' | 'backward';
export const PATH_DIRECTION_BY_DIRECTION: Record<EDirection, TPathDirection> = {
    [EDirection.FORWARD]: 'forward',
    [EDirection.BACKWARD]: 'backward',
};

export function convertPathDirectionToDirection(
    pathDirection: TPathDirection | undefined,
): EDirection {
    return (
        DIRECTIONS.find(direction => {
            return PATH_DIRECTION_BY_DIRECTION[direction] === pathDirection;
        }) ?? EDirection.FORWARD
    );
}

export function convertDirectionToPathDirection(
    direction: EDirection,
): TPathDirection {
    return PATH_DIRECTION_BY_DIRECTION[direction];
}
