import {FC, memo} from 'react';
import {useSelector} from 'react-redux';

import {IWithClassName} from 'types/withClassName';
import {WHEN_SPECIAL_VALUE} from 'types/common/When';

import {trainsCrossLinksSelector} from 'selectors/trains/direction/trainsCrossLinksSelector';

import {trainsURLs} from 'projects/trains/lib/urls';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import * as i18nBlock from 'i18n/trains-CrossLinks';

import Link from 'components/Link/Link';
import List from 'projects/trains/pages/DirectionSearchPage/components/Content/components/List/List';

import cx from './CrossLinks.scss';

export interface ICrossLinksProps extends IWithClassName {}

const CrossLinks: FC<ICrossLinksProps> = props => {
    const {className} = props;
    const {isMobile} = useDeviceType();

    const items = useSelector(trainsCrossLinksSelector);

    if (!items.length) {
        return null;
    }

    return (
        <List
            className={className}
            title={i18nBlock.title()}
            withSeparator={false}
            isMobile={isMobile}
        >
            <ul className={cx('list')}>
                {items.map(
                    ({
                        fromTitleRuNominative,
                        toTitleRuNominative,
                        fromSlug,
                        toSlug,
                    }) => {
                        const text = `${fromTitleRuNominative} — ${toTitleRuNominative}`;

                        const url = trainsURLs.getTrainsSearchUrl({
                            context: {
                                from: fromSlug,
                                to: toSlug,
                                when: WHEN_SPECIAL_VALUE.ALL_DAYS,
                            },
                        });

                        return (
                            <li key={url} className={cx('item')}>
                                <Link to={url}>{text}</Link>
                            </li>
                        );
                    },
                )}
            </ul>
        </List>
    );
};

export default memo(CrossLinks);
