import {memo, FC} from 'react';

import {IWithClassName} from 'types/withClassName';
import {ITextBlock} from 'types/common/seoPages/ITextBlocks';

import Heading from 'components/Heading/Heading';
import TextBlock from 'components/SectionTextBlock/components/TextBlock/TextBlock';

import cx from './Description.scss';

interface IDescriptionProps extends IWithClassName {
    title: string;
    text: ITextBlock;
    disclaimer: ITextBlock;
}

const Description: FC<IDescriptionProps> = props => {
    const {className, title, text, disclaimer} = props;

    return (
        <div className={cx('root', className)}>
            <Heading level={2}>{title}</Heading>

            <TextBlock className={cx('text')} block={text} />
            <TextBlock className={cx('disclaimer')} block={disclaimer} />
        </div>
    );
};

export default memo(Description);
