import {memo, FC} from 'react';

import {ITrainDirectionFAQItem} from 'types/trains/seoPages/directionSearch/blocks';
import {IWithClassName} from 'types/withClassName';

import {useDeviceType} from 'utilities/hooks/useDeviceType';

import Item from 'projects/trains/pages/DirectionSearchPage/components/Content/components/FAQ/components/Item/Item';
import List from 'projects/trains/pages/DirectionSearchPage/components/Content/components/List/List';

import cx from './FAQ.scss';

interface IFAQProps extends IWithClassName {
    items: ITrainDirectionFAQItem[];
}

const FAQ: FC<IFAQProps> = props => {
    const {className, items} = props;

    const deviceType = useDeviceType();

    return (
        <List className={cx('root', className)} isMobile={deviceType.isMobile}>
            {items.map((faqItem, index) => {
                return (
                    <Item
                        key={index}
                        question={faqItem.title}
                        answer={faqItem.text}
                    />
                );
            })}
        </List>
    );
};

export default memo(FAQ);
