import React from 'react';

import {IWithClassName} from 'types/withClassName';
import {ITextBlock} from 'types/common/seoPages/ITextBlocks';

import {deviceMods} from 'utilities/stylesUtils';
import {useBoolean} from 'utilities/hooks/useBoolean';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import ArrowBottomIcon from 'icons/16/ArrowBottom';
import TextBlock from 'components/SectionTextBlock/components/TextBlock/TextBlock';

import cx from './Item.scss';

interface ITrainSearchDescriptionFAQItemProps extends IWithClassName {
    question: string;
    answer: ITextBlock;
}

const Item: React.FC<ITrainSearchDescriptionFAQItemProps> = props => {
    const {className, question, answer} = props;

    const deviceType = useDeviceType();

    const {value: isOpened, toggle} = useBoolean(true);

    return (
        <div
            className={cx(
                'root',
                {root_active: isOpened},
                deviceMods('root', deviceType),
                className,
            )}
        >
            <div className={cx('questionWrapper')} onClick={toggle}>
                <h3 className={cx('question')}>{question}</h3>

                <div className={cx('iconWrapper')}>
                    <ArrowBottomIcon className={cx('icon')} />
                </div>
            </div>

            <TextBlock className={cx('answer')} block={answer} />
        </div>
    );
};

export default Item;
