import {memo, FC} from 'react';

import {IWithClassName} from 'types/withClassName';
import {ITextBlock} from 'types/common/seoPages/ITextBlocks';

import {deviceMods} from 'utilities/stylesUtils';
import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {
    IWithDataQaAttribute,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import Heading from 'components/Heading/Heading';
import TextBlock from 'components/SectionTextBlock/components/TextBlock/TextBlock';

import cx from './Header.scss';

interface IHeaderProps extends IWithClassName, IWithDataQaAttribute {
    title: string;
    text: ITextBlock;
}

const Header: FC<IHeaderProps> = props => {
    const {className, title, text} = props;

    const deviceType = useDeviceType();

    return (
        <div className={cx('root', deviceMods('root', deviceType), className)}>
            <Heading
                className={cx('title')}
                level={1}
                {...prepareQaAttributes({
                    parent: props,
                    current: 'title',
                })}
            >
                {title}
            </Heading>

            <TextBlock block={text} className={cx('text')} />
        </div>
    );
};

export default memo(Header);
