import React from 'react';

import {IWithClassName} from 'types/withClassName';

import Separator from 'components/Separator/Separator';

import cx from './List.scss';

export interface IListProps extends IWithClassName {
    title?: React.ReactNode;
    withSeparator?: boolean;
    children: React.ReactNode;
    isMobile: boolean;
}

const List = ({
    title,
    children,
    isMobile,
    className,
    withSeparator = true,
}: IListProps) => {
    return (
        <section className={cx(className, {root_mobile: isMobile})}>
            {title && <h2 className={cx('title')}>{title}</h2>}
            <ul className={cx('list')}>
                {React.Children.map(children, (node, index) => {
                    const key = React.isValidElement(node) ? node.key : index;

                    return (
                        <React.Fragment key={key ?? undefined}>
                            {withSeparator && (
                                <Separator
                                    margin={4}
                                    className={cx('separator')}
                                />
                            )}
                            <li className={cx('item')}>{node}</li>
                        </React.Fragment>
                    );
                })}
            </ul>
        </section>
    );
};

export default List;
