import {useSelector} from 'react-redux';

import {IWithClassName} from 'types/withClassName';

import {trainsReviewsSelector} from 'selectors/trains/direction/trainsReviewsSelector';

import * as keyset from 'i18n/trains-reviews';

import BaseReviews from 'components/Reviews/Reviews';

interface IReviewsProps extends IWithClassName {}

const Reviews: React.FC<IReviewsProps> = props => {
    const {className} = props;
    const reviews = useSelector(trainsReviewsSelector);

    return (
        <BaseReviews
            className={className}
            reviews={reviews}
            title={keyset.title()}
        />
    );
};

export default Reviews;
