import {useEffect} from 'react';
import {useDispatch} from 'react-redux';
import {batchActions} from 'redux-batched-actions';

import {
    setTrainsSearchFormEndDateFieldAction,
    setTrainsSearchFormStartDateFieldAction,
} from 'reducers/trains/searchForm/actions';

export const useDefaultDirectionPageSearchForm = (): void => {
    const dispatch = useDispatch();

    useEffect(() => {
        dispatch(
            batchActions([
                setTrainsSearchFormStartDateFieldAction(null),
                setTrainsSearchFormEndDateFieldAction(null),
            ]),
        );
    }, [dispatch]);
};
