import {createSelector} from 'reselect';

import {ESearchErrorTypes} from 'projects/trains/lib/search/constants';

import {trainsContextSelector} from 'selectors/trains/trainsContextSelector';

const isNotFoundSearchSelector = createSelector(
    trainsContextSelector,
    (context): boolean => {
        return Boolean(
            context.errors?.some(
                err => err.type === ESearchErrorTypes.POINT_NOT_FOUND,
            ),
        );
    },
);

export default isNotFoundSearchSelector;
