import {memo, FC, useMemo, useCallback} from 'react';

import {
    IFirmTrainAdvantageItem,
    IFirmTrainAdvantagesBlock,
} from 'types/trains/seoPages/firmTrain/TFirmTrainBlock';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceMods} from 'utilities/stylesUtils';

import Advantage from 'projects/trains/pages/FirmTrainPage/components/Advantages/components/Advantage/Advantage';
import Container from 'components/Layouts/Container/Container';
import Card from 'components/Card/Card';
import Flex from 'components/Flex/Flex';
import Swipeable, {
    ISwipeableRenderItemParams,
} from 'components/Swipeable/Swipeable';

import cx from './Advantages.scss';

interface IAdvantagesProps {
    block: IFirmTrainAdvantagesBlock;
}

const Advantages: FC<IAdvantagesProps> = props => {
    const {
        block: {data: blockData},
    } = props;

    const deviceType = useDeviceType();

    const renderAdvantage = useCallback(
        (item: IFirmTrainAdvantageItem) => (
            <Advantage className={cx('item')} item={item} />
        ),
        [],
    );

    const renderSwipeableAdvantage = useCallback(
        (params: ISwipeableRenderItemParams<IFirmTrainAdvantageItem>) =>
            renderAdvantage(params.data),
        [renderAdvantage],
    );

    const content = useMemo(() => {
        if (deviceType.isMobile) {
            return (
                <Card shadow="default" className={cx('card')}>
                    <Swipeable
                        className={cx('swipeable')}
                        renderItem={renderSwipeableAdvantage}
                        itemsData={blockData.items}
                        itemVerticalAlignment="flex-start"
                        showNav
                    />
                </Card>
            );
        }

        return (
            <Flex className={cx('items')} inline nowrap between={5}>
                {blockData.items.map(item => (
                    <Card
                        key={item.iconType}
                        className={cx('card')}
                        shadow="default"
                    >
                        {renderAdvantage(item)}
                    </Card>
                ))}
            </Flex>
        );
    }, [
        blockData.items,
        deviceType.isMobile,
        renderAdvantage,
        renderSwipeableAdvantage,
    ]);

    return (
        <Container className={cx('root', deviceMods('root', deviceType))}>
            {content}
        </Container>
    );
};

export default memo(Advantages);
