import {memo, FC} from 'react';

import {IFirmTrainAdvantageItem} from 'types/trains/seoPages/firmTrain/TFirmTrainBlock';
import {IWithClassName} from 'types/withClassName';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceMods} from 'utilities/stylesUtils';

import Box from 'components/Box/Box';
import Heading from 'components/Heading/Heading';
import TextBlock from 'components/SectionTextBlock/components/TextBlock/TextBlock';
import Icon from 'projects/trains/pages/FirmTrainPage/components/Advantages/components/Advantage/components/Icon/Icon';

import cx from './Advantage.scss';

interface IAdvantageProps extends IWithClassName {
    item: IFirmTrainAdvantageItem;
}

const Advantage: FC<IAdvantageProps> = props => {
    const {
        className,
        item: {title, text, iconType},
    } = props;

    const deviceType = useDeviceType();

    return (
        <div className={cx('root', className, deviceMods('root', deviceType))}>
            <Icon className={cx('icon')} type={iconType} />

            <Box className={cx('wrapper')} between={3}>
                <Heading className={cx('title')} level={2}>
                    {title}
                </Heading>

                <TextBlock
                    block={text}
                    textSize={deviceType.isMobile ? 's' : 'm'}
                />
            </Box>
        </div>
    );
};

export default memo(Advantage);
