import {FC, memo} from 'react';

import {EFirmTrainAdvantageIcon} from 'types/trains/seoPages/firmTrain/TFirmTrainBlock';
import {IWithClassName} from 'types/withClassName';

import LinearTimeM from 'icons/illustrations/LinearTime/LinearTimeM';
import LinearGoodsM from 'icons/illustrations/LinearGoods/LinearGoodsM';
import LinearPetM from 'icons/illustrations/LinearPet/LinearPetM';
import LinearTrainM from 'icons/illustrations/LinearTrain/LinearTrainM';
import LinearPeopleM from 'icons/illustrations/LinearPeople/LinearPeopleM';
import LinearEnergyM from 'icons/illustrations/LinearEnergy/LinearEnergyM';
import LinearClimateM from 'icons/illustrations/LinearClimate/LinearClimateM';
import LinearComfortM from 'icons/illustrations/LinearComfort/LinearComfortM';
import LinearTemperatureM from 'icons/illustrations/LinearTemperature/LinearTemperatureM';

import cx from './Icon.scss';

interface IIconProps extends IWithClassName {
    type: EFirmTrainAdvantageIcon;
}

const IconComponentMap = {
    [EFirmTrainAdvantageIcon.TIME]: LinearTimeM,
    [EFirmTrainAdvantageIcon.STARS]: LinearGoodsM,
    [EFirmTrainAdvantageIcon.ANIMALS]: LinearPetM,
    [EFirmTrainAdvantageIcon.TRAIN]: LinearTrainM,
    [EFirmTrainAdvantageIcon.ENERGY]: LinearEnergyM,
    [EFirmTrainAdvantageIcon.PEOPLE]: LinearPeopleM,
    [EFirmTrainAdvantageIcon.COMFORT]: LinearComfortM,
    [EFirmTrainAdvantageIcon.CLIMATE]: LinearClimateM,
    [EFirmTrainAdvantageIcon.TEMPERATURE]: LinearTemperatureM,
};

const Icon: FC<IIconProps> = props => {
    const {type, className} = props;

    const Component = IconComponentMap[type];

    return <Component className={cx('root', className)} />;
};

export default memo(Icon);
