import {memo, FC} from 'react';

import {IFirmTrainDescriptionBlock} from 'types/trains/seoPages/firmTrain/TFirmTrainBlock';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceMods} from 'utilities/stylesUtils';

import TextBlock from 'components/SectionTextBlock/components/TextBlock/TextBlock';
import Container from 'components/Layouts/Container/Container';
import Box from 'components/Box/Box';
import Heading from 'components/Heading/Heading';

import cx from './Description.scss';

interface IDescriptionProps {
    block: IFirmTrainDescriptionBlock;
}

const Description: FC<IDescriptionProps> = props => {
    const {
        block: {data: blockData},
    } = props;

    const deviceType = useDeviceType();

    return (
        <Container className={cx('root', deviceMods('root', deviceType))}>
            <Box className={cx('wrapper')} between={2}>
                <Heading className={cx('title')} level={2}>
                    {blockData.title}
                </Heading>

                <TextBlock
                    className={cx('description')}
                    block={blockData.text}
                    textSize={deviceType.isMobile ? 'm' : 'xl'}
                />
            </Box>
        </Container>
    );
};

export default memo(Description);
