import {memo, FC} from 'react';

import {IFirmTrainFaqBlock} from 'types/trains/seoPages/firmTrain/TFirmTrainBlock';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceMods} from 'utilities/stylesUtils';

import Heading from 'components/Heading/Heading';
import Box from 'components/Box/Box';
import TextBlock from 'components/SectionTextBlock/components/TextBlock/TextBlock';
import Container from 'components/Layouts/Container/Container';
import Intersperse from 'components/Intersperse/Intersperse';
import Separator from 'components/Separator/Separator';
import Card from 'components/Card/Card';

import cx from './Faq.scss';

interface IFaqProps {
    block: IFirmTrainFaqBlock;
}

const SEPARATOR = <Separator margin={6} />;

const Faq: FC<IFaqProps> = props => {
    const {
        block: {data: blockData},
    } = props;

    const deviceType = useDeviceType();

    return (
        <Container className={cx('root', deviceMods('root', deviceType))}>
            <Card
                className={cx('card')}
                shadow="default"
                between={deviceType.isMobile ? 6 : 10}
            >
                <Heading className={cx('title')} level={2}>
                    {blockData.title}
                </Heading>

                <ul className={cx('items')}>
                    <Intersperse separator={SEPARATOR}>
                        {blockData.items.map(item => (
                            <Box
                                className={cx('item')}
                                key={item.title}
                                between={deviceType.isMobile ? 3 : 4}
                                tag="li"
                            >
                                <Heading level={3} weight="bold">
                                    {item.title}
                                </Heading>

                                <TextBlock block={item.text} />
                            </Box>
                        ))}
                    </Intersperse>
                </ul>
            </Card>
        </Container>
    );
};

export default memo(Faq);
