import {FC, memo, useMemo} from 'react';

import {DELUXE_TRAIN_IDS} from 'projects/trains/constants/deluxeTrains';

import {
    EFirmTrain,
    IFirmTrainSearchFormBlock,
} from 'types/trains/seoPages/firmTrain/TFirmTrainBlock';
import {ESearchFormStyleType} from 'components/SearchForm/types';

import {deviceMods} from 'utilities/stylesUtils';
import {useDeviceType} from 'utilities/hooks/useDeviceType';
import getBackgroundImageByTrainSlug from 'projects/trains/pages/FirmTrainPage/components/SearchForm/utilities/getBackgroundImageByTrainSlug';

import Flex from 'components/Flex/Flex';
import Heading from 'components/Heading/Heading';
import Container from 'components/Layouts/Container/Container';
import TrainsSearchForm from 'projects/trains/components/SearchForm/SearchForm';

import cx from './SearchForm.scss';

interface ISearchFormProps {
    slug: EFirmTrain;
    block: IFirmTrainSearchFormBlock;
}

const SearchForm: FC<ISearchFormProps> = props => {
    const {
        slug,
        block: {data: blockData},
    } = props;

    const deviceType = useDeviceType();
    const style = useMemo(() => getBackgroundImageByTrainSlug(slug), [slug]);
    const searchFormQuery = useMemo(
        () => ({
            highSpeedTrain: String(DELUXE_TRAIN_IDS[slug]),
        }),
        [slug],
    );

    return (
        <Flex
            className={cx('root', deviceMods('root', deviceType))}
            style={style}
            justifyContent="center"
        >
            <Container>
                <Heading className={cx('title')} level={1}>
                    {blockData.title}
                </Heading>

                <TrainsSearchForm
                    className={cx('searchForm')}
                    formStyleType={ESearchFormStyleType.ROUNDED}
                    needToSetFromSuggestByGeoPosition
                    query={searchFormQuery}
                />
            </Container>
        </Flex>
    );
};

export default memo(SearchForm);
