import {EFirmTrain} from 'types/trains/seoPages/firmTrain/TFirmTrainBlock';

import checkWebPSupport from 'utilities/images/hasWebPSupport';

import sapsanBackgroundImagePng from 'images/trains/sapsan.png';
import strizhBackgroundImagePng from 'images/trains/strizh.png';
import sapsanBackgroundImageWebP from 'images/trains/sapsan.webp';
import strizhBackgroundImageWebP from 'images/trains/strizh.webp';
import lastochkaBackgroundImagePng from 'images/trains/lastochka.png';
import lastochkaBackgroundImageWebP from 'images/trains/lastochka.webp';

const hasWebPSupport = checkWebPSupport();
const backgroundImageMap = {
    [EFirmTrain.SAPSAN]: hasWebPSupport
        ? sapsanBackgroundImageWebP
        : sapsanBackgroundImagePng,
    [EFirmTrain.STRIZH]: hasWebPSupport
        ? strizhBackgroundImageWebP
        : strizhBackgroundImagePng,
    [EFirmTrain.LASTOCHKA]: hasWebPSupport
        ? lastochkaBackgroundImageWebP
        : lastochkaBackgroundImagePng,
};

const getBackgroundImageByTrainSlug = (
    slug: EFirmTrain,
): {
    backgroundImage: string;
} => {
    return {
        backgroundImage: `url(${backgroundImageMap[slug]})`,
    };
};

export default getBackgroundImageByTrainSlug;
