import React, {useEffect} from 'react';
import {useLocation} from 'react-router-dom';
import {useSelector} from 'react-redux';

import {EProjectName} from 'constants/common';

import {EFooterProject} from 'components/Footer/types';
import {EOrderApiType} from 'server/api/OrdersAPI/enums/types';
import {ETrainsGoal} from 'utilities/metrika/types/goals/trains';

import trainHappyPageSelector from 'selectors/happyPage/trainHappyPageSelector';

import getQuery from 'projects/happyPage/utilities/url/getQuery';
import {reachGoal} from 'utilities/metrika';

import ErrorPage from 'projects/happyPage/components/ErrorPage/ErrorPage';
import HappyPageLayout from 'components/Layouts/HappyPageLayout/HappyPageLayout';
import HappyPageContent from 'projects/trains/pages/HappyPage/components/HappyPageContent/HappyPageContent';

import useRequestHappyPageInfo from 'projects/happyPage/hooks/useRequestHappyPageInfo';

const HappyPage: React.FC = () => {
    const location = useLocation();

    const {orderId} = getQuery(location);

    useRequestHappyPageInfo(orderId, EOrderApiType.TRAIN);

    const {
        happyPageInfo: {value: orderAndCrossSalesInfo, errorResponse, isFailed},
    } = useSelector(trainHappyPageSelector);

    useEffect(() => {
        reachGoal(ETrainsGoal.HAPPY_PAGE_SHOWN);
    }, []);

    if (isFailed) {
        return (
            <ErrorPage
                statusCode={errorResponse?.status}
                orderType={EProjectName.TRAINS}
                footerType={EFooterProject.TRAINS}
                orderId={orderId}
            />
        );
    }

    return (
        <HappyPageLayout
            orderType={EProjectName.TRAINS}
            footerType={EFooterProject.TRAINS}
            isLoading={!orderAndCrossSalesInfo}
        >
            {orderAndCrossSalesInfo && (
                <HappyPageContent
                    orderAndCrossSalesInfo={orderAndCrossSalesInfo}
                />
            )}
        </HappyPageLayout>
    );
};

export default React.memo(HappyPage);
