import React, {useMemo, useEffect} from 'react';

import {ITrainsHpGenericOrder} from 'reducers/trains/order/types';
import {TAllSegments} from 'projects/trains/components/TrainsOrderSegments/types';

import {IOrderTripInfo} from 'selectors/trains/order/orderTripInfoSelector';

import {getOrderSegmentsByGenericOrderServices} from 'projects/trains/lib/order/getOrderSegmentsByGenericOrderServices';
import {getOrderTripInfoByGenericOrderServices} from 'projects/trains/lib/order/getOrderTripInfoByGenericOrderServices';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import TrainsOrderSegments from 'projects/trains/components/TrainsOrderSegments/TrainsOrderSegments';

interface IGenericOrderInfoProps extends IWithQaAttributes {
    order: ITrainsHpGenericOrder;
    onMount?(): void;
}

const GenericOrderInfo: React.FC<IGenericOrderInfoProps> = props => {
    const {order, onMount} = props;

    const segments = useMemo<TAllSegments>(() => {
        return getOrderSegmentsByGenericOrderServices(order.services);
    }, [order]);

    const tripInfo = useMemo<IOrderTripInfo | null>(() => {
        return getOrderTripInfoByGenericOrderServices(order.services);
    }, [order]);

    useEffect(() => {
        onMount?.();
    }, [onMount]);

    return (
        <TrainsOrderSegments
            segments={segments}
            tripInfo={tripInfo}
            canVisibleCoachInfo
            {...prepareQaAttributes('trainsOrderSegments')}
        />
    );
};

export default GenericOrderInfo;
