import {FC, memo, useEffect} from 'react';
import {useHistory} from 'react-router-dom';
import {useDispatch} from 'react-redux';

import {IHappyPageTrainServiceResponse} from 'server/services/OrdersService/types/TGetOrderHappyPageServiceResponse';
import {ETrainsGoal} from 'utilities/metrika/types/goals/trains';
import {TrainsOrderStatus} from 'server/api/TrainsBookingApi/types/TrainsOrderStatus';

import {setIsNewTrip} from 'reducers/trips/tripPage/actions';

import {useReachGoal} from 'utilities/metrika/useReachGoal';
import {accountURLs} from 'projects/account/utilities/urls';

import GenericOrderHappyPage from 'projects/trains/pages/HappyPage/components/GenericOrderHappyPage/GenericOrderHappyPage';
import SingleOrderHappyPage from 'projects/trains/pages/HappyPage/components/SingleOrderHappyPage/SingleOrderHappyPage';

import {checkTrainsHpGenericOrder} from 'server/services/TrainsService/prepareData/prepareTrainsHpGenericOrderResponse';

interface IHappyPageContentProps {
    orderAndCrossSalesInfo: IHappyPageTrainServiceResponse;
}

const HappyPageContent: FC<IHappyPageContentProps> = props => {
    const {
        orderAndCrossSalesInfo: {
            crossSale,
            order,
            order: {status},
        },
    } = props;

    const history = useHistory();
    const dispatch = useDispatch();

    const isGenericOrder = checkTrainsHpGenericOrder(order);
    const id = isGenericOrder ? order.id : order.uid;

    const reachOrderShownGoal = useReachGoal(
        ETrainsGoal.HAPPY_PAGE_ORDER_SHOWN,
    );
    const reachHotelsShownGoal = useReachGoal(
        ETrainsGoal.HAPPY_PAGE_CROSS_SALES_SHOWN,
    );
    const reachSerpGoal = useReachGoal(
        ETrainsGoal.HAPPY_PAGE_CROSS_SALES_SERP_CLICK,
    );
    const reachDetailsClick = useReachGoal(
        ETrainsGoal.HAPPY_PAGE_ORDER_DETAILS_CLICK,
    );
    const reachPromoCodeShownGoal = useReachGoal(
        ETrainsGoal.HAPPY_PAGE_PROMO_CODE_SHOWN,
    );
    const reachPromoCodeClickGoal = useReachGoal(
        ETrainsGoal.HAPPY_PAGE_PROMO_CODE_CLICK,
    );

    useEffect(() => {
        if (status !== TrainsOrderStatus.CONFIRMED) {
            history.push(accountURLs.getOrderUrl(id));
        }
    }, [history, id, status]);

    useEffect(() => {
        dispatch(setIsNewTrip(true));
    }, [dispatch]);

    if (isGenericOrder) {
        return (
            <GenericOrderHappyPage
                order={order}
                crossSale={crossSale}
                onOrderMount={reachOrderShownGoal}
                onHotelsMount={reachHotelsShownGoal}
                onAllHotelsClick={reachSerpGoal}
                onDetailsClick={reachDetailsClick}
                onPromoCodeBlockMount={reachPromoCodeShownGoal}
                onPromoCodeBlockClick={reachPromoCodeClickGoal}
            />
        );
    }

    return (
        <SingleOrderHappyPage
            order={order}
            crossSale={crossSale}
            onOrderMount={reachOrderShownGoal}
            onHotelsMount={reachHotelsShownGoal}
            onAllHotelsClick={reachSerpGoal}
            onDetailsClick={reachDetailsClick}
            onPromoCodeBlockMount={reachPromoCodeShownGoal}
            onPromoCodeBlockClick={reachPromoCodeClickGoal}
        />
    );
};

export default memo(HappyPageContent);
