import React, {useEffect, useMemo} from 'react';

import {ITrainsOrderDetails} from 'reducers/trains/order/types';

import {getPlacesFromPassengers} from '../../utilities/getPlacesFromPassengers';

import OrderMainInfo from 'projects/trains/components/OrderMainInfo/OrderMainInfo';

interface IMainInfoProps {
    order: ITrainsOrderDetails;
    onMount?(): void;
}

const OrderInfo: React.FC<IMainInfoProps> = props => {
    const {
        order: {
            stationFrom,
            stationTo,
            departure,
            arrival,
            carNumber,
            carType,
            startStation,
            endStation,
            passengers,
            trainName,
            trainNumber,
            trainTicketNumber,
            companyTitle,
        },
        onMount,
    } = props;

    const areSettlementsEqual =
        stationFrom.settlementTitle?.toLowerCase() ===
        stationTo.settlementTitle?.toLowerCase();

    const places = useMemo(
        () => getPlacesFromPassengers(passengers),
        [passengers],
    );

    useEffect(() => {
        onMount?.();
    }, [onMount]);

    return (
        <OrderMainInfo
            from={
                (areSettlementsEqual ? '' : stationFrom.settlementTitle) ||
                stationFrom.popularTitle ||
                stationFrom.title
            }
            to={
                (areSettlementsEqual ? '' : stationTo.settlementTitle) ||
                stationTo.popularTitle ||
                stationTo.title
            }
            departure={departure}
            departureTimezone={stationFrom.timezone}
            departureStation={stationFrom.popularTitle}
            arrival={arrival}
            arrivalTimezone={stationTo.timezone}
            arrivalStation={stationTo.popularTitle}
            coachNumber={carNumber.replace(/^0+/, '')}
            coachType={carType}
            startStation={startStation || ''}
            endStation={endStation || ''}
            places={places}
            trainName={trainName || ''}
            trainNumber={trainTicketNumber || trainNumber || ''}
            trainCompany={companyTitle}
        />
    );
};

export default React.memo(OrderInfo);
