import _map from 'lodash/map';
import _flow from 'lodash/flow';
import _uniq from 'lodash/uniq';
import _flatMap from 'lodash/flatMap';
import _partialRight from 'lodash/partialRight';

import {IOrderPassenger, IOrderTicket} from 'reducers/trains/order/types';

export function getPassengersTicketsCount(
    passengers: IOrderPassenger[],
): number {
    return _flow(
        _partialRight(
            _flatMap,
            (passenger: IOrderPassenger) => passenger.tickets,
        ),
        _partialRight(_map, (ticket: IOrderTicket) => ticket.blankId),
        _uniq,
    )(passengers).length;
}
