import {IOrderPassenger} from 'reducers/trains/order/types';

export function getPlacesFromPassengers(
    passengers: IOrderPassenger[],
): string[] {
    return passengers.reduce<string[]>(
        (accPassengersPlaces, {tickets}) => [
            ...accPassengersPlaces,
            ...tickets.reduce<string[]>(
                (accTicketsPlaces, {places: ticketPlaces}) => {
                    return [
                        ...accTicketsPlaces,
                        ...ticketPlaces.map(place => place.replace(/^0+/, '')),
                    ];
                },
                [],
            ),
        ],
        [],
    );
}
