import React from 'react';

import SearchLayout from 'projects/trains/components/layouts/SearchLayout/SearchLayout';
import TrainsSearchPageContent from './components/TrainsSearchPageContent/TrainsSearchPageContent';
import TrainsSearchPageFilters from './components/TrainsSearchPageFilters/TrainsSearchPageFilters';
import TrainsSearchPageFastFilters from './components/TrainsSearchPageFastFilters/TrainsSearchPageFastFilters';
import SearchPageFooter from '../../components/search/SearchPageFooter/SearchPageFooter';
import TrainsSearchPageError from './components/TrainsSearchPageError/TrainsSearchPageError';
import {TrainsGenericSearchMeta} from 'projects/trains/components/meta/TrainsGenericSearchMeta';
import TrainsSearchPageSteps from './components/TrainsSearchPageSteps/TrainsSearchPageSteps';

import {TTrainsSearchPageContainer} from './TrainsSearchPageContainer';
import {useTrainsSearchPageDataController} from './hooks/useTrainsSearchPageDataController';
import {useHasTrainsSearchPageCriticalError} from './hooks/useHasTrainsSearchPageCriticalError';
import {useTrainsSearchPageLoaderState} from './hooks/useTrainsSearchPageLoaderState';
import {useTrainsReachGoalsAfterFinishSearchPolling} from './hooks/useTrainsReachGoalsAfterFinishSearchPolling';

interface ITrainsSearchPageProps extends TTrainsSearchPageContainer {}

const TrainsSearchPage: React.FC<ITrainsSearchPageProps> = () => {
    const hasPageCriticalError = useHasTrainsSearchPageCriticalError();
    const hasPageLoader = useTrainsSearchPageLoaderState();

    useTrainsSearchPageDataController();
    useTrainsReachGoalsAfterFinishSearchPolling();

    return (
        <>
            <TrainsGenericSearchMeta />
            <SearchLayout isLoading={hasPageLoader}>
                {{
                    filters: <TrainsSearchPageFilters />,
                    fastFilters: <TrainsSearchPageFastFilters />,
                    breadcrumbs: <TrainsSearchPageSteps />,
                    content: <TrainsSearchPageContent />,
                    footer: <SearchPageFooter />,
                    error: hasPageCriticalError && <TrainsSearchPageError />,
                }}
            </SearchLayout>
        </>
    );
};

export default TrainsSearchPage;
