import _flow from 'lodash/flow';
import {withRouter, RouteComponentProps} from 'react-router-dom';

import {serverFetchDataDispatcher} from 'contexts/ServerFetchDataContext';

import {trainsPreFetchDataForGenericSearchSSR} from 'server/redux/trains/trainsPreFetchDataForGenericSearchSSR';

import TrainsSearchPage from './TrainsSearchPage';

export type TTrainsSearchPageContainer = RouteComponentProps;

export default _flow(
    withRouter,
    serverFetchDataDispatcher([trainsPreFetchDataForGenericSearchSSR]),
)(TrainsSearchPage);
