import {ESearchErrorTypes} from 'projects/trains/lib/search/constants';

import {EQueryingStatus} from 'types/trains/search/searchInfo/ITrainsSearchInfo';
import {ITrainsVariant} from 'types/trains/common/variant/ITrainsVariant';

export const checkTrainsSearchPageEmptySearch = ({
    status,
    errorCode,
    originalVariants,
}: {
    status: EQueryingStatus;
    errorCode?: ESearchErrorTypes;
    originalVariants: ITrainsVariant[];
}): boolean => {
    if (errorCode) {
        return errorCode === ESearchErrorTypes.OUT_DATE;
    }

    return status === EQueryingStatus.DONE && originalVariants.length === 0;
};
