import React, {useMemo} from 'react';
import {useDispatch, useSelector} from 'react-redux';

import {IWithClassName} from 'types/withClassName';

import {setTrainsSearchFilterValue} from 'reducers/trains/genericSearch/filters/actions';

import {getTrainsOriginalSearchFilters} from 'selectors/trains/genericSearch/filters/getTrainsOriginalSearchFilters';

import {getActiveFiltersWithTextAndValue} from 'projects/trains/lib/genericSearch/filters/getActiveFiltersWithTextAndValue';

import Card from 'components/Card/Card';
import BaseNoResultsAfterFiltration, {
    IFilterBadgeProps,
} from 'components/NoResultsAfterFiltration/NoResultsAfterFiltration';

import cx from './TrainsSearchPageEmptyResultAfterFiltration.scss';

interface ITrainsSearchPageEmptyResultAfterFiltrationProps
    extends IWithClassName {}

const TrainsSearchPageEmptyResultAfterFiltration: React.FC<ITrainsSearchPageEmptyResultAfterFiltrationProps> =
    ({className}) => {
        const dispatch = useDispatch();
        const filters = useSelector(getTrainsOriginalSearchFilters);
        const activeFilters = useMemo<IFilterBadgeProps[]>(() => {
            const activeFiltersWithTextAndValue =
                getActiveFiltersWithTextAndValue({
                    filters,
                });

            return activeFiltersWithTextAndValue.map<IFilterBadgeProps>(
                filter => {
                    return {
                        text: filter.text,
                        handler: (): void => {
                            dispatch(
                                setTrainsSearchFilterValue(filter.valueAndType),
                            );
                        },
                    };
                },
            );
        }, [filters, dispatch]);

        return (
            <Card
                className={cx('root', className)}
                shadow="default"
                x="8"
                y="8"
            >
                <BaseNoResultsAfterFiltration filters={activeFilters} />
            </Card>
        );
    };

export default TrainsSearchPageEmptyResultAfterFiltration;
