import React, {useCallback, useEffect} from 'react';
import {useDispatch, useSelector} from 'react-redux';

import {ESearchErrorTypes} from 'projects/trains/lib/search/constants';

import {ETrainsGoal} from 'utilities/metrika/types/goals/trains';

import {trainsSearchActions} from 'reducers/trains/genericSearch/search/actions';

import {getTrainsOriginalSearchInfo} from 'selectors/trains/genericSearch/search/getTrainsOriginalSearchInfo';

import {reachGoal} from 'utilities/metrika';

import NotFoundFragment from 'components/NotFound/NotFoundFragment/NotFoundFragment';
import CommonSearchError from 'projects/trains/components/CommonSearchError/CommonSearchError';
import EmptySerpWithContainer from 'components/EmptySerpWithContainer/EmptySerpWithContainer';

interface ITrainsSearchPageErrorProps {}

const TrainsSearchPageError: React.FC<ITrainsSearchPageErrorProps> = () => {
    const dispatch = useDispatch();
    const {errorCode} = useSelector(getTrainsOriginalSearchInfo);
    const startSearch = trainsSearchActions.request;

    useEffect(() => {
        reachGoal(ETrainsGoal.ERROR_PAGE_COMMON_SHOW);
    }, []);

    const handleUpdateAction = useCallback(() => {
        dispatch(startSearch(undefined));
    }, [dispatch, startSearch]);

    switch (errorCode) {
        case ESearchErrorTypes.POINT_NOT_FOUND:
            return <NotFoundFragment />;
        case ESearchErrorTypes.COMMON:
            return <CommonSearchError onUpdate={handleUpdateAction} />;
        case ESearchErrorTypes.SAME_POINTS:
            return <EmptySerpWithContainer />;
        default:
            return null;
    }
};

export default TrainsSearchPageError;
